﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Diagnostics;

using Advent.aiDevices;

namespace Advent
{
        

    /// <summary>
    /// This class contains many static functions which demonstrate how to perform level
    /// and frequency sweeps in an abstract manner.
    /// </summary>
    class Sweeps
    {


        /// <summary>
        /// This example shows how to perform a frequency sweep using the ToneGenerator and meter
        /// </summary>
        /// <param name="Gen">Tone Generator to use in the sweep</param>
        /// <param name="Level">Signal level for the sweep</param>
        /// <param name="Meter">Meter used to make measurements</param>
        /// <param name="Start">Starting frequency</param>
        /// <param name="Stop">Ending frequency</param>
        /// <param name="Points">Number of points in the sweep</param>
        /// <param name="Linger">Time to linger at each point</param>
        public static void LinearFrequencySweep(ToneGenerator Gen,       
                                                SignalLevel Level,      
                                                ISignalMeter Meter,      
                                                Frequency Start,        
                                                Frequency Stop,
                                                int Points, 
                                                TimeInterval Linger)
        {

            if (Gen.IsReserved) throw new Exception("Tone Generator is reserved");

            // Calculate the size of each frequency increment
            Frequency Inc = Frequency.InHz(1);
            if (Points >1) Inc = (Stop - Start) / (Points-1);

            // Start the signal generator with a sinusoidal tone at the starting frequency
            Gen.Generate(new Tone(Level, Start),Phase.InDegrees(0));

            for (int i = 0; i < Points; i++)
            {
                // wait the linger time
                Thread.Sleep((int)Linger.ValueInMilliseconds);      // wait the first linger time

                // Measure the signal level
                SignalLevel Measurement = Meter.Level;


                Debug.Print(Measurement.TodB().ToString() + " @ " + Gen.Frequency.ToString());

                if (i == (Points - 1)) break;

                // increment the output frequency
                Gen.Frequency += Inc;
            }
            Gen.StopGenerator();
}


    }
}
